# Adding Document-Associated Embeddings to Collections in ChromaDB

This tutorial will guide you through adding document-associated embeddings to a collection in ChromaDB.

## 1. Creating a Collection

```python
client = chromadb.Client()
morpheus_collection = client.create_collection(name="morpheus")
```

We start by initializing the ChromaDB client and creating a collection named `morpheus`.

## 2. Adding Document-Associated Embeddings

```python
morpheus_collection.add(
    documents=[
        "What if I told you everything you knew was a lie.",
        "Welcome to the real world.",
    ],
    embeddings=[[0.1, 0.2, 0.3], [0.4, 0.5, 0.6]],
    ids=["quote_1", "quote_2"],
)
```

We add two famous quotes from the character Morpheus to our collection using the `add` method. Each document is associated with:

- A unique ID
- An embedding (a list of numbers representing the semantic content of the document)

> **⚠️ Important Note:** 
> The embeddings used in this example ([0.1, 0.2, 0.3] and [0.4, 0.5, 0.6]) are purely hypothetical and for illustrative purposes only. In a real-world scenario, you would use actual embeddings generated by an embedding model or algorithm appropriate for your use case.

## 3. Counting Items in a Collection

```python
item_count = morpheus_collection.count()
print(f"Count of items in collection: {item_count}")
```

We can count the number of items in a collection using the `count` method. Since we have added two documents to our collection, the count returns `2`.

## 4. Retrieving Items from a Collection

```python
items = morpheus_collection.get()
print(items)
```

We can retrieve all items from a collection using the `get` method. By default, this will return a dictionary with the following information for each item in the collection:

- IDs
- Metadatas (if included)
- Documents

---

Please refer to the `add_doc_emb.py` file for the complete Python code used in this tutorial.